<?php

namespace Inside\Notify\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Custom notification event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CustomNotificationEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * The notification.
     *
     * @var array
     */
    public $data;

    /**
     * @var Authenticatable|null
     */
    public $user;

    /**
     * Create a new notification created event instance.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
        $this->user = Auth::user();
        if (isset($data['user_uuid'])) {
            $this->user = User::find($data['user_uuid']);
        }
    }

    /**
     * @inheritDoc
     */
    public function broadcastOn()
    {
        return new PrivateChannel('inside.notifications.'.$this->user->uuid);
    }

    /**
     * event broadcast name
     *
     * @return string
     */
    public function broadcastAs()
    {
        return 'inside.notification.dispatched';
    }
}
