<?php

namespace Inside\Notify\Console;

use Illuminate\Console\Command;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationUserView;
use Inside\Notify\Services\ExpiredNotificationCleanerService;

/**
 * Command to clean outdated notifications.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CleanOutdatedNotificationsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'notif:clean:expired';

    /**
     * @var string
     */
    protected $description = 'Clean expired notifications';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notif:clean:expired';

    public function __construct(
        private ExpiredNotificationCleanerService $expiredNotificationCleanerService
    ) {
        parent::__construct();
    }

    public function handle(): void
    {
        $this->expiredNotificationCleanerService->execute();
    }
}
