<?php

namespace Inside\Notify\Concerns;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Notifications\RoutesNotifications;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationRole;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;

/**
 * Notification trait
 *
 * @category Trait
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
trait NotifiableRole
{
    use RoutesNotifications;

    /**
     * Check if the current user has to be notified for the given notification_type_id
     *
     * @param int $notificationTypeId
     * @return bool
     */
    public function hasToBeNotified(int $notificationTypeId): bool
    {
        $roleType = NotificationTypeRole::where([
            'role_id'            => $this->id,
            'notification_type_id' => $notificationTypeId,
        ])->first();

        if ($roleType) {
            return true;
        }

        return false;
    }

    /**
     * Get the entity's notifications.
     */
    public function notifications(): mixed
    {
        return $this->belongsToMany(
            Notification::class,
            'inside_notification_role',
            'role_id',
            'notification_id'
        );
    }

    /**
     * Get user subscriptions
     */
    public function subscriptions(): mixed
    {
        return $this->belongsToMany(NotificationType::class, 'inside_notifications_type_role');
    }
}
