<?php

declare(strict_types=1);

namespace Inside\Notify\Channels;

use Exception;
use Inside\Authentication\Models\User;
use Inside\Notify\Facades\OneSignal;
use Inside\Notify\Notifications\PushNotification;

final class OneSignalChannel
{
    public function send(User $notifiable, PushNotification $notification): void
    {
        try {
            $data = $notification->toOneSignal($notifiable);
        } catch (Exception) {
            return;
        }

        if (empty($data['playerIds']) || ! OneSignal::isAvailable()) {
            return;
        }
        OneSignal::sendNotificationToPlayers($data['playerIds'], $data['body'], $data['title'], $data['url'], null, $data['additional_data']);
    }
}
