<?php

namespace Inside\Notify\Channels;

use Illuminate\Notifications\AnonymousNotifiable;
use Illuminate\Notifications\Channels\DatabaseChannel as BaseDatabaseChannel;
use Illuminate\Notifications\Notification;
use Inside\Notify\Models\NotificationRole;
use Inside\Notify\Notifications\WebNotification;

/**
 * Database channel.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class DatabaseChannel extends BaseDatabaseChannel
{
    /**
     * @inheritDoc
     */
    public function send($notifiable, Notification $notification)
    {
        /** @var WebNotification $notification */
        $data = $notification->toDatabase($notifiable);

        if ($notifiable instanceof AnonymousNotifiable) {
            return $notification;
        }

        $notification = $notifiable->routeNotificationFor('database')->create(
            [
                'notification_type_id' => $data['notification_type_id'],
                'user_uuid' => $data['user_uuid'],
                'notifiable_type' => $data['notifiable_type'],
                'notifiable_uuid' => $data['notifiable_uuid'],
                'notifiable_langcode' => $data['notifiable_langcode'],
                'type' => $data['type'] ?? 'global',
                'parent' => $data['parent'] ?? null,
                'data' => $data['data'],
                'author_uuid' => $data['author_uuid'] ?? null,
            ]
        );

        $roles = $data['roles'] ?? [];
        foreach ($roles as $role) {
            NotificationRole::firstOrCreate(
                [
                    'notification_id' => $notification->id,
                    'role_id' => $role,
                ]
            );
        }

        return $notification;
    }
}
