<?php

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class SetNotificationToBeDefaultToTrueSeeder extends Seeder
{
    public function run()
    {
        // Make all notification type to default
        NotificationType::where('profile', true)->where('via', 'web')->each(function ($type) {
            $type->default = true;
            $type->save();

            // Subscribe existant users
            User::all()->each(function ($user) use ($type) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $type->id,
                ]);
            });
        });
    }
}
