<?php

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class NewsFeaturedWebNotificationSeeder extends Seeder
{
    public function run()
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\News',
                'action'    => 'createOrUpdate',
                'condition' => 'is_featured:1|status:1',
                'multiple'  => false,
                'language'  => true,
                'profile'   => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.news.featured.title',
                    'description' => 'notifications.create.news.featured.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.news.featured.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            if ($notificationType) {
                User::all()->each(function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate([
                        'user_uuid'            => $user->uuid,
                        'notification_type_id' => $notificationType->id,
                    ]);
                });

                $this->command->info('Notifications created, '.User::count().' subscribers');
                continue;
            }
            $this->command->info('Notifications created, no subscribers');
        }
    }
}
