<?php

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class NewsFeaturedMailNotificationSeeder extends Seeder
{
    public function run()
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => false,
                'event'     => 'Inside\Content\Events\ContentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\News',
                'action'    => 'createOrUpdate',
                'condition' => 'is_featured:1|status:1',
                'multiple'  => false,
                'language'  => true,
                'profile'   => true,
                'data'      => [
                    'title'       => 'notifications.create.news.featured.mail.title',
                    'description' => 'notifications.create.news.featured.mail.description',
                    'mail'        => [
                        'subject'    => 'notifications.create.news.featured.mail.subject',
                        'text'       => 'notifications.create.news.featured.mail.content',
                        'buttonText' => 'notifications.create.news.featured.mail.buttonText',
                    ],
                ],
            ]
        );

        $this->command->info('Notifications created, no subscribers');
    }
}
