<?php

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class BirthdayNotificationSeeder extends Seeder
{
    public function run()
    {
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => '',
                'action' => 'birthday',
                'type' => 'global',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.birthday.title',
                    'description' => 'notifications.birthday.description',
                    'text' => 'notifications.birthday.text',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                    ],
                ],
            ]
        );

        if ($notificationType) {
            Users::all()->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid' => $user->uuid,
                    'notification_type_id' => $notificationType->id,
                ]);
            });
        }
    }
}
