<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Notify\Models\Notification;

final class AlterWebNotificationsGedUrl extends Migration
{
    public function up(): void
    {
        Notification::query()
            ->where('data', 'LIKE', '%"url":"\\\/ged%')
            ->each(function ($notification) {
                $notification->data = str_replace('/ged', 'ged', $notification->data);
                $notification->save();
            });
    }
}
