<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class DisableManualNotificationTypes extends Migration
{
    public function up(): void
    {
        if (config('app.code') === 'club') {
            return;
        }

        $notificationTypes = NotificationType::where('action', 'manualNotificationsSend')
            ->pluck('id')
            ->toArray();

        NotificationSubscriber::whereIn('notification_type_id', $notificationTypes)->delete();

        NotificationType::whereIn('id', $notificationTypes)->delete();
    }
}
