<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CreateMentionNotificationTypes extends Migration
{
    use HasConsole;

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $contentTypes = ['news', 'events', 'documents'];

        $commentNotificationType = NotificationType::query()->where([
            'via' => 'web',
            'action' => 'contentCommented',
        ])->first();

        if ($commentNotificationType) {
            $condition = explode('|', $commentNotificationType->condition);
            $condition = explode(':', $condition[0]);

            if ($condition[0] === 'parent_type') {
                $contentTypes = explode(',', $condition[1]);
            }
        }

        // Someone commented a user content
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\UserMentionedInCommentEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'userMentioned',
                'type'      => 'global',
                'condition' => 'parent_type:'.implode(',', $contentTypes),
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data' => [
                    'title'       => 'notifications.mention.title',
                    'description' => 'notifications.mention.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.mention.text',
                    'fields'      => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        // Someone answer someone else comment
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\UserMentionedInCommentEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'userMentionedInResponse',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data' => [
                    'title'       => 'notifications.mention.title',
                    'description' => 'notifications.mention.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.mention.text',
                    'fields'      => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        // Someone commented a user content
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\UserMentionedInCommentEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'userMentioned',
                'type' => 'global',
                'condition' => 'parent_type:'.implode(',', $contentTypes),
                'multiple' => true,
                'language' => false,
                'profile' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.mention.mail.title',
                    'description' => 'notifications.mention.mail.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.content.<content_type>.text',
                    'mail' => [
                        'subject' => 'notifications.mention.mail.subject',
                        'text' => 'notifications.mention.mail.text',
                        'buttonText' => 'notifications.mention.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        // Someone answer someone else comment
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event'     => 'Inside\Content\Events\UserMentionedInCommentEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'userMentionedInResponse',
                'type' => 'global',
                'condition' => null,
                'multiple' => true,
                'language' => false,
                'profile' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.mention.mail.title',
                    'description' => 'notifications.mention.mail.description',
                    'icon' => 'comment',
                    'text' => 'notifications.mention.mail.text',
                    'mail' => [
                        'subject' => 'notifications.mention.mail.subject',
                        'text' => 'notifications.mention.mail.text',
                        'buttonText' => 'notifications.mention.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                    'url' => 'ROOT_RELATION:'.implode(',', $contentTypes),
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid'            => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
            $this->writeln('Notifications created, '.Users::count().' subscribers');
        }
    }

    public function down(): void
    {
        NotificationType::query()->whereIn('action', ['userMentioned', 'userMentionedInResponse'])->delete();
    }
}
