<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CleanOldFollowNotifications extends Migration
{
    public function up(): void
    {
        NotificationType::where('via', 'web')->where('data', 'like', '%"title":"notifications.title"%')
            ->each(function ($notificationType) {
                $data = $notificationType->data;
                $type = class_to_type($notificationType->model);
                $data['title'] = 'notifications.create.content.'.$type.'.title';
                $data['description'] = 'notifications.create.content.'.$type.'.description';
                $data['text'] = 'notifications.create.content.'.$type.'.text';
                $notificationType->data = $data;
                $notificationType->save();
            });
    }

    public function down(): void
    {
    }
}
