<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddTitleFieldsToReportNotification extends Migration
{
    public function up(): void
    {
        NotificationType::query()
            ->where('action', 'report')
            ->where('condition', '=', null)
            ->each(function ($type) {
                $type->data = array_merge($type->data, ['fields' => ['title', 'author', 'content_type']]);
                $type->save();
            });
    }

    public function down(): void
    {
    }
}
