<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Content;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationRole;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Facades\Role as RoleService;
use Inside\Permission\Models\Role;

class FixRoleNotificationsWithSpecificPermissions extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $notificationTypes = NotificationType::query()->where('role', 1)->where('via', 'web')->get();

        foreach ($notificationTypes as $notificationType) {
            $notifications = Notification::query()->where('notification_type_id', $notificationType->id)->get();
            foreach ($notifications as $notification) {
                if (empty($notification->notifiable_type) || empty($notification->notifiable_uuid)) {
                    continue;
                }

                $model = call_user_func($notification->notifiable_type.'::find', $notification->notifiable_uuid);

                if (! $model || ! $model instanceof Content) {
                    continue;
                }

                $hasSpecific = DB::table('inside_permissions_schema')->join(
                    'inside_roles_permissions_schema',
                    function ($join) {
                        $join->on(
                            'inside_roles_permissions_schema.permission_schema_id',
                            '=',
                            'inside_permissions_schema.id'
                        );
                    }
                )->where('inside_permissions_schema.authorizable_uuid', $model->uuid)->where(
                    'inside_roles_permissions_schema.is_content_specific',
                    true
                )->where('inside_permissions_schema.action', 'read')->exists();

                if (! $hasSpecific) {
                    continue;
                }

                $roles = Role::all();

                NotificationRole::query()->where('notification_id', $notification->id)->delete();

                foreach ($roles as $role) {
                    if ($role->name === 'super_administrator' || RoleService::can('read', $model, $role->id)) {
                        NotificationRole::query()->create([
                            'notification_id' => $notification->id,
                            'role_id' => $role->id,
                        ]);
                    }
                }
            }
        }
    }

    public function down(): void
    {
    }
}
