<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeActivityNotificationsToGroupedNotifications extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $authenticatedRole = Inside\Permission\Models\Role::where('name', 'authenticated')->first();

        $notificationTypes = Inside\Notify\Models\NotificationType::where('type', 'activity')->get();
        $notificationTypes->each(
            function ($type) use ($authenticatedRole) {
                $type->role = true;
                $type->save();
                Inside\Notify\Models\NotificationTypeRole::firstOrCreate(
                    [
                        'notification_type_id' => $type->id,
                        'role_id' => $authenticatedRole->id,
                    ]
                );

                $keepNotifsIds = Inside\Notify\Models\Notification::where('notification_type_id', $type->id)
                    ->pluck('id', 'notifiable_uuid')
                    ->unique();

                Inside\Notify\Models\Notification::where('notification_type_id', $type->id)
                    ->whereNotIn('id', $keepNotifsIds)
                    ->delete();

                Inside\Notify\Models\Notification::find($keepNotifsIds)
                    ->each(
                        function ($notif) {
                            $notif->user_uuid = null;
                            $notif->author_uuid = $notif->data['from'] ?? null;
                            $notif->save();
                        }
                    );
            }
        );
    }

    public function down(): void
    {
    }
}
