<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationTypeRoleTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_notifications_type_role')) {
            Schema::create(
                'inside_notifications_type_role',
                function (Blueprint $table) {
                    $table->increments('id')->collate('utf8');
                    $table->integer('notification_type_id')->collate('utf8')->unsigned();
                    $table->integer('role_id')->collate('utf8')->unsigned();

                    $table->foreign('notification_type_id')->references('id')->on('inside_notifications_types')->onDelete('cascade');
                    $table->foreign('role_id')->references('id')->on('inside_roles')->onDelete('cascade');

                    $table->unique(['role_id', 'notification_type_id'], 'notification_type_role_unique');
                }
            );
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_notifications_type_role');
    }
}
