<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AlterNotificationsTableColumnsAuthorUser extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement('ALTER TABLE `inside_notifications` MODIFY `user_uuid` CHAR(36) NULL;');

        Schema::table(
            'inside_notifications',
            function (Blueprint $table) {
                $table->uuid('author_uuid')->collate('utf8')->nullable();
            }
        );
    }

    public function down(): void
    {
        DB::statement('ALTER TABLE `inside_notifications` MODIFY `user_uuid` CHAR(36) NOT NULL;');
        Schema::table(
            'inside_notifications',
            function (Blueprint $table) {
                $table->dropColumn('author_uuid');
            }
        );
    }
}
