<?php

use Illuminate\Database\Migrations\Migration;

class FixReportOnCommentEmail extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix report
        Inside\Notify\Models\NotificationType::where([
            ['via', '=', 'email'],
            ['default', '=', false],
            ['event', '=', 'Inside\Notify\Events\CustomNotificationListener'],
            ['model', '=', 'Inside\Content\Models\Contents\Comments'],
            ['action', '=', 'report'],
            ['condition', '=', ''],
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['url'] = 'ROOT_RELATION:news';
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
