<?php

use Illuminate\Database\Migrations\Migration;

class FixAuthorFields extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix authors
        Inside\Notify\Models\NotificationType::where(
            'data',
            'like',
            '%"fields":[{"author":[%'
        )->each(function ($notificationType) {
            $data = $notificationType->data;
            if (isset($data['fields']['author'])) {
                $data['fields']['authors'] = $data['fields']['author'];
                unset($data['fields']['author']);
                $notificationType->data = $data;
                $notificationType->save();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
