<?php

use Illuminate\Database\Migrations\Migration;

class FixFeaturedNewsEmail extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix like
        Inside\Notify\Models\NotificationType::where([
            'via'       => 'email',
            'default'   => false,
            'event'     => 'Inside\Content\Events\ContentCreatedEvent',
            'model'     => 'Inside\Content\Models\Contents\News',
            'action'    => 'createOrUpdate',
            'condition' => 'is_featured:1|status:1',
            'multiple'  => false,
            'language'  => true,
            'profile'   => true,
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['fields'] = [
                'title',
            ];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
