<?php

use Illuminate\Database\Migrations\Migration;

class FixReportWeb extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix report
        Inside\Notify\Models\NotificationType::where([
            ['via', '=', 'web'],
            ['default', '=', false],
            ['event', '=', 'Inside\Notify\Events\CustomNotificationListener'],
            ['model', '=', 'Inside\Content\Models\Contents\Comments'],
            ['action', '=', 'report'],
            ['condition', '=', ''],
        ])->each(function ($notificationType) {
            $data = $notificationType->data;
            $data['fields'] = [['notification-data.from' => ['firstname', 'lastname']], ['structures' => ['title', 'slug']]];
            $notificationType->data = $data;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
