<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTypesTable extends Migration
{
    /**
     * Data to be inserted into the table
     *
     * @var array
     */
    protected $types = [
        // Comments
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Content\Events\ContentCreatedEvent',
            'model'     => 'Inside\Content\Models\Contents\Comments',
            'action'    => 'create',
            'condition' => 'parent.author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'        => 'notifications.comment.create.title',
                'description'  => 'notifications.comment.create.description',
                'icon'         => 'comment',
                'text'         => 'notifications.comment.create.text',
                'extra_fields' => ['uuid', 'content_type'],
                'fields'       => [['author' => ['firstname', 'lastname']], ['newsReverse' => ['title']]],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Content\Events\ContentCreatedEvent',
            'model'     => 'Inside\Content\Models\Contents\Comments',
            'action'    => 'create',
            'condition' => 'parent.author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'        => 'notifications.comment.answer.title',
                'description'  => 'notifications.comment.answer.description',
                'icon'         => 'comment',
                'text'         => 'notifications.comment.answer.text',
                'extra_fields' => ['uuid', 'content_type'],
                'fields'       => [['author' => ['firstname', 'lastname']], ['newsReverse' => ['title']]],
            ],
        ],
        // Reaction
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => '',
            'action'    => 'follow',
            'condition' => 'uuid:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'       => 'notifications.reaction.follow.title',
                'description' => 'notifications.reaction.follow.description',
                'icon'        => 'follow',
                'text'        => 'notifications.reaction.follow.text',
                'fields'      => [['notification-data.from' => ['firstname', 'lastname']]],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => '',
            'action'    => 'like',
            'condition' => 'author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'       => 'notifications.reaction.like.title',
                'description' => 'notifications.reaction.like.description',
                'icon'        => 'like',
                'text'        => 'notifications.reaction.like.text',
                'fields'      => [['notification-data.from' => ['firstname', 'lastname']], 'title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => 'Inside\Content\Models\Contents\Events',
            'action'    => 'join',
            'condition' => 'author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'       => 'notifications.reaction.join.events.title',
                'description' => 'notifications.reaction.join.events.description',
                'icon'        => 'join',
                'text'        => 'notifications.reaction.join.events.text',
                'fields'      => [['notification-data.from' => ['firstname', 'lastname']], 'title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => 'Inside\Content\Models\Contents\Events',
            'action'    => 'join',
            'condition' => '',
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'          => 'notifications.reaction.join.events.delay.d-1.title',
                'description'    => 'notifications.reaction.join.events.delay.d-1.description',
                'delay_from'     => 'date',
                'delay_interval' => '-P1D', // Minus 1 Day
                'icon'           => 'join',
                'text'           => 'notifications.reaction.join.events.delay.d-1.text',
                'fields'         => ['title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => 'Inside\Content\Models\Contents\Events',
            'action'    => 'join',
            'condition' => '',
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'          => 'notifications.reaction.join.events.delay.d-7.title',
                'description'    => 'notifications.reaction.join.events.delay.d-7.description',
                'delay_from'     => 'date',
                'delay_interval' => '-P7D', // Minus 7 Day
                'icon'           => 'join',
                'text'           => 'notifications.reaction.join.events.delay.d-7.text',
                'fields'         => ['title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => 'Inside\Content\Models\Contents\Events',
            'action'    => 'join',
            'condition' => '',
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'          => 'notifications.reaction.join.events.delay.h-23.title',
                'description'    => 'notifications.reaction.join.events.delay.h-23.description',
                'delay_from'     => 'date',
                'delay_interval' => '-PT23H', // Minus 23 Hour
                'icon'           => 'join',
                'text'           => 'notifications.reaction.join.events.delay.h-23.text',
                'fields'         => ['title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'     => 'Inside\Content\Models\Contents\Events',
            'action'    => 'join',
            'condition' => '',
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'          => 'notifications.reaction.join.events.delay.h-1.title',
                'description'    => 'notifications.reaction.join.events.delay.h-1.description',
                'delay_from'     => 'date',
                'delay_interval' => '-PT1H', // Minus 1 Hour
                'icon'           => 'join',
                'text'           => 'notifications.reaction.join.events.delay.h-1.text',
                'fields'         => ['title'],
            ],
        ],
        // System
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Authentication\Events\AuthenticationLoginEvent',
            'model'     => '',
            'action'    => 'login',
            'condition' => 'uuid:CURRENT_USER',
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'       => 'notifications.user.login.first.title',
                'description' => 'notifications.user.login.first.description',
                'icon'        => 'login',
                'text'        => 'notifications.user.login.first.text',
                'fields'      => ['firstname', 'lastname'],
            ],
        ],
        // Custom
        [
            'via'       => 'web',
            'default'   => true,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Documents',
            'action'    => 'report',
            'condition' => 'author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'       => 'notifications.custom.report.documents.title',
                'description' => 'notifications.custom.report.documents.description',
                'icon'        => 'report',
                'text'        => 'notifications.custom.report.documents.text',
                'fields'      => [['author' => ['firstname', 'lastname']], 'title'],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => false,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Documents',
            'action'    => 'report',
            'condition' => '',
            'multiple'  => true,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'       => 'notifications.custom.report.documents.title',
                'description' => 'notifications.custom.report.documents.description',
                'icon'        => 'report',
                'text'        => 'notifications.custom.report.documents.text',
                'fields'      => [['notification-data.from' => ['firstname', 'lastname']], 'title'],
            ],
        ],
        [
            'via'       => 'email',
            'default'   => false,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Documents',
            'action'    => 'report',
            'condition' => 'author:CURRENT_USER',
            'multiple'  => true,
            'language'  => false,
            'profile'   => true,
            'data'      => [
                'title'       => 'notifications.custom.report.documents.mail.title',
                'description' => 'notifications.custom.report.documents.mail.description',
                'mail'        => [
                    'subject'    => 'notifications.custom.report.documents.mail.subject',
                    'text'       => 'notifications.custom.report.documents.mail.content',
                    'buttonText' => 'notifications.custom.report.documents.mail.buttonText',
                ],
            ],
        ],
        [
            'via'       => 'web',
            'default'   => false,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Comments',
            'action'    => 'report',
            'condition' => '',
            'multiple'  => true,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'       => 'notifications.custom.report.comments.title',
                'description' => 'notifications.custom.report.comments.description',
                'icon'        => 'report',
                'text'        => 'notifications.custom.report.comments.text',
                'fields'      => [['notification-data.from' => ['firstname', 'lastname']], ['structures' => ['title', 'slug']]],
            ],
        ],
        [
            'via'       => 'email',
            'default'   => false,
            'event'     => 'Inside\Notify\Events\CustomNotificationListener',
            'model'     => 'Inside\Content\Models\Contents\Comments',
            'action'    => 'report',
            'condition' => '',
            'multiple'  => true,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'       => 'notifications.custom.report.comments.mail.title',
                'description' => 'notifications.custom.report.comments.mail.description',
                'mail'        => [
                    'subject'    => 'notifications.custom.report.comments.mail.subject',
                    'text'       => 'notifications.custom.report.comments.mail.content',
                    'buttonText' => 'notifications.custom.report.comments.mail.buttonText',
                ],
            ],
        ],
    ];

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_notifications_types')) {
            Schema::create('inside_notifications_types', function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->enum('via', ['web', 'email', 'sms', 'slack', 'push']);
                $table->boolean('default')->default(0);
                $table->string('event', 255)->nullable();
                $table->string('model', 255)->nullable();
                $table->string('action', 255)->nullable();
                $table->string('condition', 255)->nullable();
                $table->boolean('multiple')->default(0);
                $table->boolean('language')->default(0);
                $table->boolean('profile')->default(0);
                $table->longText('data')->nullable();
            });

            foreach ($this->types as &$type) {
                $type['data'] = json_encode($type['data']);
                DB::table('inside_notifications_types')->insert($type);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_notifications_types');
    }
}
