<?php

use Illuminate\Support\Str;

if (! function_exists('menu_class_to_type')) {
    function menu_class_to_type(string $class = ''): string
    {
        return str_replace('_menu_link', '', Str::snake(class_basename($class)));
    }
}

if (! function_exists('menu_type_to_class')) {
    function menu_type_to_class(string $type = ''): string
    {
        return 'Inside\\Menu\\Models\\'.Str::studly($type.'_menu_link');
    }
}

if (! function_exists('menu_table_to_class')) {
    function menu_table_to_class(string $table = ''): ?string
    {
        if ($table) {
            $type = str_replace('inside_menu_', '', $table);

            return menu_type_to_class($type);
        }

        return null;
    }
}

if (! function_exists('menu_class_to_table')) {
    function menu_class_to_table(string $class = ''): ?string
    {
        if ($class) {
            $table = str_replace('Inside\Menu\Models\\', 'inside_menu', $class);

            return str_replace('_menu_link', '', Str::snake($table));
        }

        return null;
    }
}

if (! function_exists('menu_type_to_table')) {
    function menu_type_to_table(string $type = ''): string
    {
        return 'inside_menu_'.Str::snake($type);
    }
}

if (! function_exists('has_menu_link')) {
    function has_menu_link(string $needle, array $haystack): bool
    {
        return array_key_exists($needle, $haystack);
    }
}
