<?php

namespace Inside\Menu\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Menu\Contracts\Menu;
use Inside\Menu\Models\MenuLink;

class Update extends Controller
{
    public function __invoke(Request $request, Menu $menu, string $menuName, string $uuid): JsonResponse
    {
        $this->checkArguments($menuName, $uuid);

        if ($request->has('weight') || $request->has('parent_id')) {
            $menuLink = $this->move($request, $menu, $menuName, $uuid);
        } else {
            $menuLink = $this->update($request, $menu, $menuName, $uuid);
        }

        return $this->success($menu, $menuLink);
    }

    protected function move(Request $request, Menu $menu, string $menuName, string $uuid): MenuLink
    {
        $data = $request->only(['weight', 'parent_id']);
        $data['parent_id'] = [
            'menu_name' => $menuName,
            'parent_id' => $data['parent_id'] ?? null,
        ];
        $request['parent_id'] = $data['parent_id'];
        $this->handleImage($request, $data);
        $this->validate($request, $this->getValidationRules($data));

        return $menu->move($menuName, $uuid, $data);
    }

    protected function update(Request $request, Menu $menu, string $menuName, string $uuid): MenuLink
    {
        $data = $request->only([
            'title',
            'langcode',
            'link',
            'status',
            'display',
            'icon',
            'image',
            'color',
            'page',
            'page_params',
            'link_type',
            'open_in_new_tab',
            'hide_on_mobile',
        ]);
        $this->handleImage($request, $data);
        $this->validate($request, $this->getValidationRules($data));

        return $menu->update($menuName, $uuid, $data);
    }
}
