<?php

namespace Inside\Menu\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Menu\Contracts\Menu;

class Links extends Controller
{
    public function __invoke(Request $request, Menu $menu, string $menuName): JsonResponse
    {
        $this->checkArguments($menuName);

        $admin = Str::contains($request->path(), 'admin/menu');
        /** @var User $user */
        $user = Auth::user();
        $filters = json_decode($request->get('filters'), true) ?? [];
        $langcode = in_array($filters['langcode'], list_languages())
            ? $filters['langcode']
            : $user->langcode;

        return new JsonResponse([
            'success' => true,
            'data' => $menu->getMenuLinks($menuName, $langcode, $admin),
        ]);
    }
}
