<?php

namespace Inside\Menu\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Menu\Contracts\Menu;

class Create extends Controller
{
    public function __invoke(Request $request, Menu $menu, string $menuName): JsonResponse
    {
        $this->checkArguments($menuName);

        $data = $request->only([
            'title',
            'langcode',
            'link',
            'status',
            'display',
            'icon',
            'image',
            'color',
            'page',
            'page_params',
            'link_type',
            'open_in_new_tab',
            'hide_on_mobile',
        ]);
        $this->handleImage($request, $data);

        $this->validate($request, $this->getValidationRules($data));

        return $this->success($menu, $menu->create($menuName, $data));
    }
}
