<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => '\Inside\Layout\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('layout/build', ['uses' => 'LayoutController@build']);
        $router->get('layout', ['uses' => 'LayoutController@current']);
        $router->get('layouts', ['uses' => 'LayoutController@list']);
        $router->post('layout', ['uses' => 'LayoutController@create']);
        $router->delete('layout/{id}', ['uses' => 'LayoutController@delete']);
        $router->put('layout/{id}', ['uses' => 'LayoutController@update']);
    }
);
