<?php

namespace Inside\Layout\Validators;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Inside\Layout\Exceptions\ValidatorException;

class LayoutValidator
{
    /**
     * @param array $data
     * @param int|null $id
     * @return array
     */
    protected function rules(array $data, ?int $id = null): array
    {
        $rules = [
            'path'   => ['array', 'min:1'],
            'layout' => ['required', 'json'],
            'option' => ['json'],
        ];

        if (! isset($data['path'])) {
            return $rules;
        }

        foreach (array_keys($data['path']) as $index) {
            $langcode = $data['path'][$index]['langcode'];
            $rules['path.'.$index.'.path'] = [
                'required',
                'string',
                'min:3',
                'max:255',
                Rule::unique('inside_layouts_paths', 'path')
                    ->ignore($id, 'layout_id')
                    ->where(function ($query) use ($langcode) {
                        return $query->where('langcode', $langcode);
                    }),
            ];
            $rules['path.'.$index.'.langcode'] = ['required', 'string', 'size:2'];
        }

        return $rules;
    }

    /**
     * @param array $data
     * @param int|null $id
     * @return void
     */
    public function validate(array $data, ?int $id = null): void
    {
        $rules = $this->rules($data, $id);
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            throw new ValidatorException($validator->errors());
        }
    }
}
