<?php

namespace Inside\Layout\Repositories\Contracts;

interface LayoutRepositoryInterface
{
    /**
     * @param string $path
     * @param string $langcode
     * @return mixed
     * @throws \Inside\Layout\Exceptions\NeedRedirectToLayout
     */
    public function current(string $path, string $langcode);

    /**
     * @param array $data
     * @return \Inside\Layout\Models\Layout
     * @throws \Inside\Layout\Exceptions\ValidatorException
     */
    public function create(array $data);

    /**
     * @param array $data
     * @param int $id
     * @param string $attribute
     * @return mixed
     * @throws \Inside\Layout\Exceptions\ValidatorException
     */
    public function update(array $data, int $id, string $attribute = 'id');

    /**
     * @param int $id
     * @param string $attribute
     * @return mixed
     */
    public function delete(int $id, string $attribute = 'id');
}
