<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterLayoutsPathsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (! Schema::hasColumn('inside_layouts_paths', 'langcode')) {
            Schema::table('inside_layouts_paths', function (Blueprint $table) {
                $table->char('langcode', 2)->nullable()->after('path');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('inside_layouts_paths', 'langcode')) {
            Schema::table('inside_layouts_paths', function (Blueprint $table) {
                $table->dropColumn('langcode');
            });
        }
    }
}
