<?php

namespace Inside\Kernel\Providers;

use Inside\Kernel\Authentication\SingleSingOnRedirectionService;
use Inside\Kernel\Environment\EnvironmentService;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

class KernelServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(SingleSingOnRedirectionService::class, function () {
            return new SingleSingOnRedirectionService();
        });

        $this->app->singleton(EnvironmentService::class, function () {
            return new EnvironmentService();
        });

        $this->mergeConfigTo(__DIR__.'/../../config/app.php', 'app');
    }
}
