<?php

namespace Inside\Kernel\Filesystem;

use Illuminate\Http\UploadedFile;
use League\MimeTypeDetection\FinfoMimeTypeDetector;
use Symfony\Component\HttpFoundation\File\MimeType\MimeTypeGuesser;
use Symfony\Component\Mime\MimeTypes;

final class MimeTypeValidatorService
{
    public function validate(UploadedFile $file): bool
    {
        MimeTypeGuesser::reset();

        $allowedExtensions = collect([
            'file_extensions'  => setting('contentManagement', 'file_extensions', '[]'),
            'img_extensions'   => setting('contentManagement', 'img_extensions', '[]'),
            'video_extensions' => setting('contentManagement', 'video_extensions', '[]'),
        ])
            ->map(fn ($ext) => collect(json_decode($ext, true)))
            ->flatten()
            ->filter()
            ->unique()
            ->values();

        $mimeTypesUtil = new MimeTypes();
        $allowedMimeTypes = collect($allowedExtensions)
            ->flatMap(function ($ext) use ($mimeTypesUtil) {
                return $mimeTypesUtil->getMimeTypes($ext);
            })
            ->filter()
            ->unique()
            ->values()
            ->all();

        $allowedMimeTypes = array_merge($allowedMimeTypes, config('allowed_mimetypes', []));

        $detector = new FinfoMimeTypeDetector();
        $detectedMime = $detector->detectMimeTypeFromFile($file->getPathname());

        return in_array($detectedMime, $allowedMimeTypes);
    }
}
