<?php

namespace Inside\Kernel\Environment;

final class EnvironmentService
{
    private const DEVELOPMENT = 'development';

    private const STAGING = 'staging';

    private const PRODUCTION = 'production';

    private const ALLOWED_ENVS = [
        self::PRODUCTION,
        self::DEVELOPMENT,
        self::STAGING,
    ];

    public function getEnvironment(): string
    {
        $env = env('APP_ENV', self::PRODUCTION);

        return in_array($env, self::ALLOWED_ENVS) ? $env : self::PRODUCTION;
    }

    public function isDebugEnabled(): bool
    {
        return $this->getEnvironment() === self::DEVELOPMENT
            ? (bool) env('APP_DEBUG', false)
            : false;
    }

    public function isProtectedFilesDisabled(): bool
    {
        return $this->getEnvironment() === self::DEVELOPMENT;
    }
}
