<?php

namespace Inside\Kernel\Authentication;

use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Log;

final class StoreIntendedPathService
{
    const INTENDED_PATH_KEY = '_inside_intended_path';

    public static function store(string $path): void
    {
        $path = str($path)->start('/')->toString();

        if (str($path)->startsWith('/themes/custom') || str($path)->contains('.')) {
            return;
        }

        Log::debug('[Kernel] Store intended path through cookie: '.$path);

        Cookie::queue(self::INTENDED_PATH_KEY, $path, 5);
    }

    public static function retrieve(): ?string
    {
        /** @var string|null $path */
        $path = Cookie::get(self::INTENDED_PATH_KEY, '/');

        Log::debug('[Kernel] Retrieve intended path from cookie: '.$path);

        return $path;
    }

    public static function forget(): void
    {
        Log::debug('[Kernel] Forget intended path from cookie');

        Cookie::queue(Cookie::forget(self::INTENDED_PATH_KEY));
    }

    public static function exists(): bool
    {
        return Cookie::has(self::INTENDED_PATH_KEY);
    }
}
