<?php

namespace Inside\Kernel\Authentication\Facades;

use Illuminate\Support\Facades\Facade;
use Inside\Kernel\Authentication\SingleSingOnRedirectionService;

/**
 * @method static bool isEnabled()
 * @method static bool isProtected(string $path)
 * @method static void enable()
 * @method static void disable()
 * @method static SingleSingOnRedirectionService setProvider(string $provider)
 * @method static string getLoginUrl()
 * @method static string getLogoutUrl()
 */
final class SingleSingOnRedirection extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return SingleSingOnRedirectionService::class;
    }
}
