<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;
use Inside\Routing\Router;

Route::group(
    [
        'namespace' => 'Inside\I18n\Http\Controllers',
    ],
    function ($router) {
        $router->get(
            'lang.json',
            [
                'uses' => 'TranslationController@getFrontLang',
                'as'   => 'inside.i18n.front.lang',
            ]
        );
    }
);

Route::group(
    [
        'namespace'  => 'Inside\I18n\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => ['auth.backoffice.access:translation'],
    ],
    function ($router) {
        $router->get(
            'locales',
            [
                'uses' => 'LanguageController@index',
                'as'   => 'inside.i18n.locales',
            ]
        );

        $router->get(
            'translations',
            [
                'uses' => 'TranslationController@index',
                'as'   => 'inside.i18n.index',
            ]
        );

        $router->get(
            'translations/groups',
            [
                'uses' => 'TranslationController@groupIndex',
                'as'   => 'inside.i18n.groups',
            ]
        );

        $router->get(
            'translations/filters',
            [
                'uses' => 'TranslationController@getIndexFilters',
                'as'   => 'inside.i18n.filters',
            ]
        );

        $router->get(
            'translations/export',
            [
                'uses' => 'TranslationController@exportDatabase',
                'as'   => 'inside.i18n.export',
            ]
        );

        $router->put(
            'translations/export/dev/{id}',
            [
                'uses' => 'TranslationController@markTranslationAsExportable',
                'as'   => 'inside.i18n.mark.exportable',
            ]
        );

        $router->delete(
            'translations/export/dev/{id}',
            [
                'uses' => 'TranslationController@unmarkTranslationAsExportable',
                'as'   => 'inside.i18n.unmark.exportable',
            ]
        );

        $router->get(
            'translations/export/dev',
            [
                'uses' => 'TranslationController@exportDatabaseForDev',
                'as'   => 'inside.i18n.export',
            ]
        );

        $router->post(
            'translations/import',
            [
                'uses' => 'TranslationController@importDatabase',
                'as'   => 'inside.i18n.import',
            ]
        );

        $router->post(
            'translations/synchronize',
            [
                'uses' => 'TranslationController@synchronize',
                'as'   => 'inside.i18n.synchronize',
            ]
        );

        $router->get(
            'translations/overrides',
            [
                'uses' => 'TranslationController@getOverrides',
                'as'   => 'inside.i18n.overrides',
            ]
        );

        $router->post(
            'translations/cache/clear',
            [
                'uses' => 'TranslationController@cacheClear',
                'as'   => 'inside.i18n.cache.clear',
            ]
        );

        $router->get(
            'translations/{key}',
            [
                'uses' => 'TranslationController@show',
                'as'   => 'inside.i18n.show',
            ]
        );

        $router->post(
            'translations',
            [
                'uses' => 'TranslationController@store',
                'as'   => 'inside.i18n.store',
            ]
        );

        $router->put(
            'translations/{id}',
            [
                'uses' => 'TranslationController@update',
                'as'   => 'inside.i18n.update',
            ]
        );

        $router->post(
            'translations/{key}',
            [
                'uses' => 'TranslationController@updateTranslations',
                'as'   => 'inside.i18n.update.translations',
            ]
        );

        $router->delete(
            'translations/{locale}',
            [
                'uses' => 'TranslationController@deleteOverridedTranslationsByKey',
                'as'   => 'inside.i18n.delete.translation',
            ]
        );

        $router->delete(
            'translations/system/{id}',
            [
                'uses' => 'TranslationController@destroy',
                'as'   => 'inside.i18n.destroy',
            ]
        );

        $router->patch(
            'translations/{id}/lock',
            [
                'uses' => 'TranslationController@lock',
                'as'   => 'inside.i18n.index',
            ]
        );

        $router->patch(
            'translations/{id}/unlock',
            [
                'uses' => 'TranslationController@unlock',
                'as'   => 'inside.i18n.unlock',
            ]
        );

        $router->patch(
            'translations/{key}/exportable/{locale}',
            [
                'uses' => 'TranslationController@markTranslationAsExportable',
                'as'   => 'inside.i18n.exportable',
            ]
        );

        $router->patch(
            'translations/{key}/unexportable/{locale}',
            [
                'uses' => 'TranslationController@unmarkTranslationAsExportable',
                'as'   => 'inside.i18n.unexportable',
            ]
        );

        $router->patch(
            'translations/{id}/validate',
            [
                'uses' => 'TranslationController@validate',
                'as'   => 'inside.i18n.validate',
            ]
        );

        $router->patch(
            'translations/{id}/invalidate',
            [
                'uses' => 'TranslationController@invalidate',
                'as'   => 'inside.i18n.invalidate',
            ]
        );
    }
);

Route::group(
    [
        'namespace'  => 'Inside\I18n\Http\Controllers',
        'prefix'     => 'api/v1',
    ],
    function (Router $router) {
        // Live Translate
        $router->post('translate', ['uses' => 'LiveTranslateController']);
    }
);
