<?php

declare(strict_types=1);

namespace Inside\I18n\Models\Traits;

use Illuminate\Support\Facades\App;

class TranslationObserver
{
    /**
     *  Save translations when model is saved.
     *
     * @param \Inside\I18n\Models\Translation $translation
     * @return void
     */
    public function saved($translation)
    {
        if ($translation->text === null) {
            return;
        }

        $cacheRepository = App::make('inside.translation.cache.repository');
        $cacheRepository->flush($translation->language->locale, $translation->group, $translation->namespace);
    }
}
