<?php

declare(strict_types=1);

namespace Inside\I18n\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $hash
 * @property array $original
 * @property array $translation
 * @property string $source_lang
 * @property string $target_lang
 * @property string $translator
 *
 * @method static Builder query()
 * @method static void truncate()
 * @method static static create(array $attributes = []);
 */
final class LiveTranslation extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_live_translations';

    public $timestamps = false;

    protected $fillable = [
        'hash',
        'source_lang',
        'target_lang',
        'original',
        'translation',
        'translator',
    ];

    protected $casts = [
        'original' => 'array',
        'translation' => 'array',
    ];
}
