<?php

declare(strict_types=1);

namespace Inside\I18n\Loaders;

use Illuminate\Support\Arr;
use Inside\I18n\Repositories\TranslationRepository;

/**
 * Class DatabaseLoader
 */
final class DatabaseLoader extends AbstractLoader
{
    public function __construct(
        string $defaultLocale,
        protected TranslationRepository $translationRepository
    ) {
        parent::__construct($defaultLocale);
    }

    public function loadSource(string $locale, string $group, ?string $namespace = '*'): array
    {
        $dotArray = $this->translationRepository->loadSource($locale, $namespace, $group);
        $source = [];
        foreach ($dotArray as $item => $text) {
            Arr::set($source, $item, $text);
        }

        return Arr::dot($source);
    }

    /**
     * Add namespace
     */
    public function addNamespace($namespace, $hint)
    {
        $this->namespaces[$namespace] = $hint;
    }

    /**
     * @param string $path
     */
    public function addJsonPath($path): void
    {
        // No effect
    }
}
