<?php

declare(strict_types=1);

namespace Inside\I18n\Jobs;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Cache;
use Inside\I18n\Facades\Translation;
use Inside\I18n\Models\CachedTranslation;
use Inside\Jobs\Job;

/**
 * Class ClearCachedTranslations
 */
final class ClearCachedTranslations extends Job
{
    public function handle(): void
    {
        CachedTranslation::truncate();
        $cacheRepository = App::make('inside.translation.cache.repository');
        $cacheRepository->flushAll();
        Cache::tags('translations')->flush();
        // Ask to restart workers
        Artisan::call('queue:restart');
        Translation::rebuildCachedTranslations();
    }
}
