<?php

declare(strict_types=1);

namespace Inside\I18n\Jobs;

use Illuminate\Support\Facades\Log;
use Inside\I18n\Models\Language;
use Inside\I18n\Models\Translation;
use Inside\I18n\Repositories\LanguageRepository;
use Inside\I18n\Repositories\TranslationRepository;
use Inside\Jobs\Job;

final class CleanupTranslations extends Job
{
    public function handle(): void
    {
        $languageRepository = new LanguageRepository(new Language(), app());
        $repository = new TranslationRepository(new Translation(), app(), $languageRepository);

        foreach ($languageRepository->allLanguages() as $locale => $name) {
            $filters = [
                'draft'  => false,
                'state'  => 'translated',
                'locale' => $locale,
            ];
            // Check overrides translation
            $overrides = $repository->getOverrideItems($filters);

            $translations = collect();
            $translations = $translations->merge($repository->getCoreTranslations($filters));
            $translations = $translations->merge($repository->getFrontTranslations($filters));

            foreach ($overrides as $override) {
                // Get value without overrides
                if ($translations->has($override->code) && $override->text === $translations[$override->code]->text) {
                    Log::debug(
                        'Translation key['.$override->key.'] for locale ['.$locale.'] needs to be clean'
                    );
                    $override->delete();
                }
            }
        }
    }
}
