<?php

declare(strict_types=1);

namespace Inside\I18n\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\I18n\Contracts\LiveTranslator;

final class LiveTranslateController extends Controller
{
    public function __invoke(Request $request, LiveTranslator $translator): JsonResponse
    {
        $sourceLang = $request->get('source_lang');
        $targetLang = $request->get('target_lang');
        $text = $request->get('text');

        if ($targetLang === null) {
            /** @var User $user */
            $user = Auth::user();
            $targetLang = $user->langcode;
        }

        $translation = $translator->getLiveTranslation(Arr::wrap($text), $targetLang, $sourceLang);

        return response()->json([
            'text' => $translation->translation,
            'source_lang' => $translation->source_lang,
            'target_lang' => $translation->target_lang,
            'translator' => $translation->translator,
        ]);
    }
}
