<?php

namespace Inside\I18n\Console\Commands;

use Inside\Console\Command;
use Inside\I18n\Repositories\TranslationRepository;

class SynchroniseTranslationsCommand extends Command
{
    /** @var TranslationRepository */
    protected $translationRepository;

    protected $signature = 'inside:translation:sync';

    public function __construct(TranslationRepository $translationRepository)
    {
        parent::__construct();
        $this->translationRepository = $translationRepository;
    }

    public function handle(): void
    {
        dd($this->translationRepository->findTranslations());
    }
}
