<?php

namespace Inside\I18n\Cache;

class TaggedCacheRepository extends AbstractCacheRepository
{
    public function has(string $locale, string $group, ?string $namespace): bool
    {
        return ! is_null($this->get($locale, $group, $namespace));
    }

    public function get(string $locale, string $group, ?string $namespace): ?array
    {
        $key = $this->getKey($locale, $group, $namespace);

        return $this->store->tags([$this->cacheTag, $key])->get($key);
    }

    public function put(string $locale, string $group, ?string $namespace, ?array $content, int $lifeTime)
    {
        $key = $this->getKey($locale, $group, $namespace);

        $this->store->tags([$this->cacheTag, $key])->put($key, $content, $lifeTime);
    }

    public function flush(string $locale, string $group, string $namespace)
    {
        $key = $this->getKey($locale, $group, $namespace);

        $this->store->tags([$key])->flush();
    }

    public function flushAll()
    {
        $this->store->tags([$this->cacheTag])->flush();
    }
}
