<?php

namespace Inside\I18n\Cache;

interface CacheRepositoryInterface
{
    /**
     * Does we have languages $locale for this group on namespace
     *
     * @param string $locale
     * @param string $group
     * @param string|null $namespace
     * @return bool
     */
    public function has(string $locale, string $group, ?string $namespace): bool;

    /**
     * Getting languages $locale for this group on namespace
     *
     * @param string $locale
     * @param string $group
     * @param string|null $namespace
     * @return array|null
     */
    public function get(string $locale, string $group, ?string $namespace): ?array;

    /**
     * Saving languages $locale for this group on namespace
     *
     * @param string $locale
     * @param string $group
     * @param string|null $namespace
     * @param array|null $content
     * @param int $lifeTime
     * @return mixed
     */
    public function put(string $locale, string $group, ?string $namespace, ?array $content, int $lifeTime);

    /**
     * Flushing languages $locale for this group on namespace
     *
     * @param string $locale
     * @param string $group
     * @param string $namespace
     * @return mixed
     */
    public function flush(string $locale, string $group, string $namespace);

    /**
     * Flush all!
     *
     * @return mixed
     */
    public function flushAll();
}
