<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;

class AlterInsideCachedTranslationsKeyLength extends Migration
{
    public $withinTransaction = true;

    public function up(): void
    {
        if (config('database.default') === 'pgsql') {
            DB::statement('ALTER TABLE inside_translations ALTER COLUMN "key" TYPE VARCHAR(255)');
            DB::statement('ALTER TABLE inside_cached_translations ALTER COLUMN "key" TYPE VARCHAR(255)');
        } else {
            DB::statement('ALTER TABLE `inside_translations` CHANGE `key` `key` VARCHAR(255)');
            DB::statement('ALTER TABLE `inside_cached_translations` CHANGE `key` `key` VARCHAR(255)');
        }
    }
}
