<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideTranslationsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_translations',
            function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('language_id');
                $table->foreign('language_id')->references('id')->on('inside_languages');
                $table->string('namespace', 150)->default('*')->index();
                $table->string('group', 150)->index();
                $table->string('key', 150);
                $table->text('text')->nullable();
                $table->boolean('draft')->default(true)->index();
                $table->boolean('locked')->default(false)->index();
                $table->boolean('exportable')->default(false)->index();
                $table->timestamps();
                $table->unique(['language_id', 'namespace', 'group', 'key']);
            }
        );
    }

    public function down(): void
    {
        Schema::drop('inside_translations');
    }
}
