<?php

return [
    /**
     * Le comportement par défaut est d'utiliser la langue principale quand une traduction
     * n'est pas disponible dans la langue courante.
     *
     * Pour modifier le comportement générale, il faut mettre use_fallback à false
     * On peut changer le comportement directement dans le model en mettant la propriété
     *
     * protected $useTranslationFallback = false;
     *
     * Note: la langue principale est définie par 'app.locale' ou l'env APP_LOCALE
     */
    'use_fallback' => true,

    'deepl' => [
        'uri' => env('DEEPL_URI', 'https://api-free.deepl.com/v2/translate'),
        'auth_key' => env('DEEPL_AUTH_KEY'),
    ],
];
