<?php

namespace Inside\Horizon\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class GenerateSystemdCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'horizon:generate-systemd';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate a systemd service file for Horizon';

    public function handle()
    {
        $content = str_replace(
            ['{PHP}', '{ARTISAN}', '{USER}', '{WORKING_DIRECTORY}'],
            [PHP_BINARY, cms_base_path('artisan'), get_current_user(), cms_base_path()],
            file_get_contents(__DIR__.'/../../stubs/horizon.service.stub')
        );

        $path = cms_base_path('horizon.service');

        File::put($path, $content);

        $this->warn("Systemd service file generated at: {$path}");
        $this->info("To enable the service, run: sudo cp {$path} /etc/systemd/system/horizon.service");
        $this->info('To reload the service, run: sudo systemctl daemon-reload');
        $this->info('To enable the service, run: sudo systemctl enable horizon');
        $this->info('To start the service, run: sudo systemctl start horizon');
    }
}
